<?php $d = weather::$datas; ?>
<?php if (!empty($d['error'])): ?>
    <div class="block">
        <h4><?php echo helper::translate('Erreur'); ?></h4>
        <div class="row">
            <div class="col12">
                <p style="color:#b00020;margin:0;"><strong><?php echo htmlspecialchars($d['error']); ?></strong></p>
            </div>
        </div>
    </div>
<?php elseif (!empty($d['weather'])): ?>
    <div class="block">
        <h4><?php echo helper::translate('Météo du jour'); ?></h4>
        <div class="row">
            <div class="col6">
                <div class="weatherCurrent" style="display:flex;align-items:center;gap:12px;">
                    <?php if (!empty($d['weather']['current']['condition_icon'])): ?>
                        <img src="<?php echo htmlspecialchars($d['weather']['current']['condition_icon']); ?>" alt="" width="64" height="64">
                    <?php endif; ?>
                    <div>
                        <div class="conditionText"><?php echo htmlspecialchars($d['weather']['current']['condition_text'] ?? ''); ?></div>
                        <div class="currentDetails">
                            <?php $units = (!empty($d['units']) && $d['units'] === 'imperial') ? 'imperial' : 'metric'; ?>
                            <?php if ($units === 'imperial'): ?>
                                <?php echo helper::translate('Température'); ?>: <strong><?php echo htmlspecialchars((string)$d['weather']['current']['temp_f']); ?> °F</strong>
                                <?php if ($d['weather']['current']['feelslike_f'] !== null): ?>
                                    &nbsp;(<small><?php echo helper::translate('ressenti'); ?> <?php echo htmlspecialchars((string)$d['weather']['current']['feelslike_f']); ?> °F</small>)
                                <?php endif; ?>
                                <?php if ($d['weather']['current']['wind_mph'] !== null): ?>
                                    <br><?php echo helper::translate('Vent'); ?>: <?php echo htmlspecialchars((string)$d['weather']['current']['wind_mph']); ?> mph <?php echo htmlspecialchars($d['weather']['current']['wind_dir'] ?? ''); ?>
                                <?php endif; ?>
                            <?php else: ?>
                                <?php echo helper::translate('Température'); ?>: <strong><?php echo htmlspecialchars((string)$d['weather']['current']['temp_c']); ?> °C</strong>
                                <?php if ($d['weather']['current']['feelslike_c'] !== null): ?>
                                    &nbsp;(<small><?php echo helper::translate('ressenti'); ?> <?php echo htmlspecialchars((string)$d['weather']['current']['feelslike_c']); ?> °C</small>)
                                <?php endif; ?>
                                <?php if ($d['weather']['current']['wind_kph'] !== null): ?>
                                    <br><?php echo helper::translate('Vent'); ?>: <?php echo htmlspecialchars((string)$d['weather']['current']['wind_kph']); ?> km/h <?php echo htmlspecialchars($d['weather']['current']['wind_dir'] ?? ''); ?>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if ($d['weather']['current']['humidity'] !== null): ?>
                                <br><?php echo helper::translate('Humidité'); ?>: <?php echo htmlspecialchars((string)$d['weather']['current']['humidity']); ?> %
                            <?php endif; ?>
                            <br><small style="opacity:.8;">
                                <?php echo helper::translate('Ville'); ?>: <?php echo htmlspecialchars($d['config']['city']); ?>
                                <?php if (!empty($d['weather']['location']['country'])): ?> — <?php echo helper::translate('Pays'); ?>: <?php echo htmlspecialchars($d['weather']['location']['country']); ?><?php endif; ?>
                                <?php if (!empty($d['weather']['location']['localtime'])): ?> — <?php echo helper::translate('Heure locale'); ?>: <?php echo htmlspecialchars($d['weather']['location']['localtime']); ?><?php endif; ?>
                            </small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col6">
                <?php if (!empty($d['weather']['current']['air_quality']) && !empty($d['config']['aqi'])): ?>
                    <div class="weatherAqi">
                        <div class="aqiTitle"><?php echo helper::translate("Qualité de l'air"); ?></div>
                        <div class="aqiDetails">
                            <?php $aq = $d['weather']['current']['air_quality']; ?>
                            <?php if (isset($aq['pm2_5'])): ?>PM2.5: <?php echo htmlspecialchars((string)$aq['pm2_5']); ?> µg/m³<br><?php endif; ?>
                            <?php if (isset($aq['pm10'])): ?>PM10: <?php echo htmlspecialchars((string)$aq['pm10']); ?> µg/m³<br><?php endif; ?>
                            <?php if (isset($aq['o3'])): ?>O3: <?php echo htmlspecialchars((string)$aq['o3']); ?> µg/m³<br><?php endif; ?>
                            <?php if (isset($aq['no2'])): ?>NO2: <?php echo htmlspecialchars((string)$aq['no2']); ?> µg/m³<br><?php endif; ?>
                            <?php if (isset($aq['so2'])): ?>SO2: <?php echo htmlspecialchars((string)$aq['so2']); ?> µg/m³<br><?php endif; ?>
                            <?php if (isset($aq['co'])): ?>CO: <?php echo htmlspecialchars((string)$aq['co']); ?> µg/m³<?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php if (!empty($d['config']['alerts']) && !empty($d['weather']['alerts'])): ?>
        <div class="block">
            <h4><?php echo helper::translate('Alertes météo'); ?></h4>
            <div class="row">
                <?php foreach ($d['weather']['alerts'] as $al): ?>
                    <div class="col12" style="margin-bottom:10px;">
                        <div style="border-left:4px solid #b00020;background:#fff3f3;padding:8px 12px;border-radius:6px;">
                            <?php if (!empty($al['headline']) || !empty($al['event'])): ?>
                                <div style="font-weight:600;">
                                    <?php echo htmlspecialchars($al['headline'] ?? $al['event']); ?>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($al['effective_fmt']) || !empty($al['expires_fmt'])): ?>
                                <div style="opacity:.8;">
                                    <?php if (!empty($al['effective_fmt'])): ?><?php echo helper::translate('Début'); ?>: <?php echo htmlspecialchars($al['effective_fmt']); ?><?php endif; ?>
                                    <?php if (!empty($al['expires_fmt'])): ?> — <?php echo helper::translate('Fin'); ?>: <?php echo htmlspecialchars($al['expires_fmt']); ?><?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($al['severity']) || !empty($al['areas'])): ?>
                                <div style="opacity:.8;">
                                    <?php if (!empty($al['severity'])): ?><?php echo helper::translate('Gravité'); ?>: <?php echo htmlspecialchars($al['severity']); ?><?php endif; ?>
                                    <?php if (!empty($al['areas'])): ?> — <?php echo helper::translate('Zones'); ?>: <?php echo htmlspecialchars($al['areas']); ?><?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($al['desc'])): ?>
                                <div style="margin-top:6px;">&nbsp;<?php echo nl2br(htmlspecialchars($al['desc'])); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
    <?php if (!empty($d['weather']['forecast'])): ?>
        <div class="block">
            <h4><?php echo helper::translate('Prévisions'); ?> (<?php echo count($d['weather']['forecast']); ?> <?php echo helper::translate('jours'); ?>   )</h4>
            <div class="row">
                <?php foreach ($d['weather']['forecast'] as $d0): ?>
                    <div class="col4" style="margin-bottom:10px;">
                        <div style="border:1px solid #ddd;padding:8px;border-radius:6px;">
                            <div><strong><?php echo htmlspecialchars($d0['date']); ?></strong></div>
                            <div style="display:flex;align-items:center;gap:8px;margin:6px 0;">
                                <?php if (!empty($d0['day']['condition_icon'])): ?>
                                    <img src="<?php echo htmlspecialchars($d0['day']['condition_icon']); ?>" alt="" width="48" height="48">
                                <?php endif; ?>
                                <span><?php echo htmlspecialchars($d0['day']['condition_text'] ?? ''); ?></span>
                            </div>
                            <?php $units = (!empty($d['units']) && $d['units'] === 'imperial') ? 'imperial' : 'metric'; ?>
                            <?php if ($units === 'imperial'): ?>
                                <div><?php echo helper::translate('Max'); ?>: <?php echo htmlspecialchars((string)$d0['day']['maxtemp_f']); ?> °F &nbsp; <?php echo helper::translate('Min'); ?>: <?php echo htmlspecialchars((string)$d0['day']['mintemp_f']); ?> °F</div>
                                <?php if ($d0['day']['avgtemp_f'] !== null): ?><div><?php echo helper::translate('Moy'); ?>: <?php echo htmlspecialchars((string)$d0['day']['avgtemp_f']); ?> °F</div><?php endif; ?>
                            <?php else: ?>
                                <div><?php echo helper::translate('Max'); ?>: <?php echo htmlspecialchars((string)$d0['day']['maxtemp_c']); ?> °C &nbsp; <?php echo helper::translate('Min'); ?>: <?php echo htmlspecialchars((string)$d0['day']['mintemp_c']); ?> °C</div>
                                <?php if ($d0['day']['avgtemp_c'] !== null): ?><div><?php echo helper::translate('Moy'); ?>: <?php echo htmlspecialchars((string)$d0['day']['avgtemp_c']); ?> °C</div><?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
    <!-- Pied de page -->
    <div style="text-align:center;margin-top:16px;opacity:.7;font-size:12px;">
        <?php echo helper::translate('Données météo fournies par'); ?> <a href="https://www.weatherapi.com/" title="Free Weather API" style="color:#0066cc;">WeatherAPI.com</a>
    </div>
<?php else: ?>
    <div class="block">
        <h4><?php echo helper::translate('Météo'); ?></h4>
        <div class="row">
            <div class="col12">
                <p style="opacity:.7;margin:0;"><?php echo helper::translate('Aucune donnée météo à afficher.'); ?></p>
            </div>
        </div>
    </div>
<?php endif; ?>
