# Widget Météo pour ZwiiCMS

**Module d'affichage météo basé sur Open-Meteo**

## 📌 Description

Ce module permet d'afficher un **widget météo** sur les pages de votre site ZwiiCMS, en utilisant les données du module **forecast_openmeteo**. Il propose :
- Un affichage compact des conditions météo actuelles.
- Une prévision horaire sur 6 heures.
- Une redirection personnalisable vers une page météo détaillée.
- Une configuration simple via l'interface admin.

---

## 📦 Installation

1. **Copier le module** :
   - Placez le dossier `widget_meteo` dans le répertoire `module/` de votre installation ZwiiCMS.

2. **Configurer le module** :
   - Ajoutez le module à une page via l'éditeur ZwiiCMS.
   - Accédez à la configuration du module pour définir l'URL de redirection (optionnelle).

---

## 🛠️ Configuration

### Paramètres disponibles

**URL de redirection**  Lien vers une page météo détaillée (laisser vide pour désactiver). | `https://mon-site.com/meteo` |

### Fichier de données
Le module lit les données météo depuis : site/data/weather_openmeteo/weather.json

- Ce fichier doit être généré par le module **forecast_openmeteo** (à installer séparément).

---

## 📝 Utilisation

### Affichage du widget
- Le widget s'affiche automatiquement sur les pages où il est inséré.
- En mode visiteur, il montre :
  - La température actuelle.
  - Les conditions météo (soleil, pluie, etc.).
  - Le vent, l'humidité, et les heures de lever/coucher du soleil.
  - Une prévision horaire sur 6 heures.

- **Clic sur le widget** :
  - Si une URL de redirection est configurée, le clic redirige vers cette page.

### Mode admin
- En mode **configuration**, le module affiche un formulaire pour personnaliser l'URL de redirection.

---

## 💡 Astuces

### Positionnement des modules dans ZwiiCMS
Les modules ZwiiCMS **ne peuvent pas être alignés à un endroit précis** sur votre page avec l'éditeur intégré. Par défaut, ils sont centrés en haut ou en bas de page, ou à l'endroit de l'appel via le mot-clé `[MODULE]`.

**Pour remédier à cela** :
- Créez un **tableau à une ou deux colonnes** avec l'éditeur intégré de ZwiiCMS.
- Avec **Épaisseur de la bordure** réglée à 0, le tableau sera transparent.
- Insérez le mot-clé `[MODULE]` dans la cellule de votre choix.
- Le module s'affichera alors **exactement à l'endroit souhaité** dans votre mise en page.
  
---

## 🔧 Dépendances
- **ZwiiCMS** (version 13.7 ou supérieure).
- **Module forecast_openmeteo** (pour générer le fichier `weather.json`).

---

## 📜 Licence
Ce module est distribué sous licence **CC BY-NC-ND 4.0** (Attribution - Pas d’Utilisation Commerciale - Pas de Modification).
- **Auteur** : Michel Tuboeuf
- **Site** : [ZwiiCMS](https://zwiicms.fr/)

---

## 💡 Remarques
- Ce module est conçu pour être **léger et simple** : aucune base de données n'est requise.
