<?php
$redirectUrl = widget_meteo::$datas['redirectUrl'] ?? '';
$moduleId = widget_meteo::$datas['moduleId'] ?? '';
?>

<?php echo template::formOpen('widgetMeteoConfig'); ?>
<div class="row">
    <div class="col1">
        <?php echo template::button('widgetMeteoConfigBack', [
            'href' => helper::baseUrl() . $moduleId,
            'value' => template::ico('left')
        ]); ?>
    </div>
    <div class="col2 offset9">
        <?php echo template::submit('widgetMeteoConfigSubmit', [
            'value' => 'Enregistrer'
        ]); ?>
    </div>
</div>

<div class="row">
    <div class="col12">
        <div class="block">
            <h4><?php echo helper::translate('Configuration du Widget Météo'); ?></h4>

            <div class="row">
                <div class="col12">
                    <?php echo template::text('widget_meteoRedirectUrl', [
                        'label' => 'URL de redirection',
                        'value' => $redirectUrl,
                        'placeholder' => 'https://mon_site.com/meteo-complete',
                        'help' => 'URL vers laquelle rediriger lorsque l\'utilisateur clique sur le widget. Laissez vide pour désactiver le clic.'
                    ]); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo template::formClose(); ?>

<div class="row">
    <div class="col12">
        <div class="block">
            <h4><?php echo helper::translate('Informations du module'); ?></h4>

            <div class="moduleInfo">
                <p><strong><?php echo helper::translate('Fonctionnement :'); ?></strong>
                    <?php echo helper::translate('Ce widget affiche les données météo provenant du module OpenMeteo et permet une redirection vers une page dédiée.'); ?></p>

                <p><strong><?php echo helper::translate('Fichier de données :'); ?></strong>
                    <?php echo helper::translate('Les données sont lues depuis'); ?> <code>site/data/weather_openmeteo/weather.json</code></p>
            </div>
        </div>
    </div>
    <div class="block">
        <div class="module-version">
            <strong>Module Widget OpenMeteo</strong> - Version <?php echo widget_meteo::VERSION; ?>
        </div>
    </div>
</div>