<?php
$city = widget_meteo::$datas['city'] ?? '';
$latitude = widget_meteo::$datas['latitude'] ?? '';
$longitude = widget_meteo::$datas['longitude'] ?? '';
$redirectUrl = widget_meteo::$datas['redirectUrl'] ?? '';
$dataSource = widget_meteo::$datas['dataSource'] ?? 'api';
$moduleId = widget_meteo::$datas['moduleId'] ?? '';
?>

<?php echo template::formOpen('widgetMeteoConfig'); ?>
<div class="row">
    <div class="col1">
        <?php echo template::button('widgetMeteoConfigBack', [
            'href' => helper::baseUrl() . $moduleId,
            'value' => template::ico('left')
        ]); ?>
    </div>
    <div class="col2 offset9">
        <?php echo template::submit('widgetMeteoConfigSubmit', [
            'value' => 'Enregistrer'
        ]); ?>
    </div>
</div>

<div class="row">
    <div class="col12">
        <div class="block">
            <h4><?php echo helper::translate('Configuration du Widget Météo'); ?></h4>

            <div class="row">
                <div class="col6">
                    <?php echo template::text('city', [
                        'label' => 'Nom de la ville',
                        'value' => $city,
                        'placeholder' => 'Ex: Paris',
                        'help' => 'Nom affiché dans le widget (API direct)'
                    ]); ?>
                </div>
                <div class="col3">
                    <?php echo template::text('latitude', [
                        'label' => 'Latitude',
                        'value' => $latitude,
                        'placeholder' => 'Ex: 48.8566',
                        'help' => 'Coordonnée GPS latitude'
                    ]); ?>
                </div>
                <div class="col3">
                    <?php echo template::text('longitude', [
                        'label' => 'Longitude',
                        'value' => $longitude,
                        'placeholder' => 'Ex: 2.3522',
                        'help' => 'Coordonnée GPS longitude'
                    ]); ?>
                </div>
            </div>

            <div class="row">
                <div class="col6">
                    <?php echo template::select('dataSource', [
                        'api' => 'API Open-Meteo (direct)',
                        'file' => 'Fichier externe (module forecast_openmeteo)'
                    ], [
                        'label' => 'Source des données',
                        'selected' => $dataSource,
                        'help' => 'Choisissez la source des données météo',
                        'id' => 'dataSource'
                    ]); ?>
                </div>
                <div class="col6">
                    <?php echo template::text('redirectUrl', [
                        'label' => 'URL de redirection',
                        'value' => $redirectUrl,
                        'placeholder' => 'https://mon_site.com/meteo-complete',
                        'help' => 'URL vers laquelle rediriger lorsque l\'utilisateur clique sur le widget. Laissez vide pour désactiver le clic.',
                        'id' => 'redirectUrl'
                    ]); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo template::formClose(); ?>

<div class="row">
    <div class="col12">
        <div class="block">
            <h4><?php echo helper::translate('Informations du module'); ?></h4>
            <div class="moduleInfo">

                <div class="alert alert-success">
                    <strong>Mode API Open-Meteo (direct)</strong><br>
                    Les données sont récupérées directement depuis l'API Open-Meteo.
                    Aucun module externe requis. Service gratuit sans clé API.
                </div>
                <div class="alert alert-success">
                    <strong>Mode Fichier externe</strong><br>
                    Les données sont lues depuis <code>site/data/weather_openmeteo/weather.json</code><br>
                    Ce fichier doit être généré par le module forecast_openmeteo (à installer séparément).
                </div>
                <div class="alert alert-info">
                    <strong>Coordonnées GPS :</strong> Vous pouvez trouver les coordonnées de votre ville sur <a href="https://www.latlong.net/" target="_blank">latlong.net</a> ou sur <a href="https://www.coordonnees-gps.fr/" target="_blank">Coordonnées GPS</a><br>
                    <strong>Source API :</strong> <a href="https://open-meteo.com/" target="_blank">Open-Meteo</a> - Service gratuit et sans clé API
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col12">
        <div class="block">
            <div class="module-version">
                <strong>Module Widget Météo</strong> - Version <?php echo widget_meteo::VERSION; ?>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const dataSourceSelect = document.getElementById('dataSource');
        const redirectUrlField = document.querySelector('[name="redirectUrl"]');

        // Fonction pour masquer/désactiver le champ redirectUrl
        function toggleRedirectUrl() {
            const redirectUrlContainer = redirectUrlField.closest('.col6');

            if (dataSourceSelect.value === 'api') {
                redirectUrlField.disabled = true;
                if (redirectUrlContainer) {
                    redirectUrlContainer.style.display = 'none';
                }
            } else {
                redirectUrlField.disabled = false;
                if (redirectUrlContainer) {
                    redirectUrlContainer.style.display = 'block';
                }
            }
        }

        // Appeler la fonction au chargement de la page
        toggleRedirectUrl();

        // Appeler la fonction à chaque changement de la sélection
        dataSourceSelect.addEventListener('change', toggleRedirectUrl);
    });
</script>