<?php
$weather = widget_meteo::$datas['weather'] ?? null;
$weatherData = widget_meteo::$datas['weatherData'] ?? null;
$redirectUrl = widget_meteo::$datas['redirectUrl'] ?? '';
$moduleId = widget_meteo::$datas['moduleId'] ?? '';

// Fonction pour obtenir l'icône météo améliorée jour/nuit
function getWeatherIcon($iconEmoji, $isDay = true)
{
    // Mapping des emojis jour/nuit
    $icons = [
        '☀️' => $isDay ? '☀️' : '🌙',       // Ciel dégagé
        '🌤️' => $isDay ? '🌤️' : '🌙☁️',    // Principalement dégagé
        '⛅' => $isDay ? '⛅' : '☁️🌙',    // Partiellement nuageux
        '☁️' => '☁️',                       // Couvert
        '🌧️' => $isDay ? '🌧️' : '🌧️🌙',    // Pluie
        '🌦️' => $isDay ? '🌦️' : '🌧️🌙',    // Pluie légère
        '⛈️' => '⛈️',                       // Orage
        '🌨️' => '🌨️',                       // Neige
        '❄️' => $isDay ? '❄️' : '❄️🌙',    // Neige
        '🌫️' => $isDay ? '🌫️' : '🌫️🌙',    // Brouillard
    ];

    return $icons[$iconEmoji] ?? $iconEmoji;
}

// Vérifier si les données météo sont disponibles
if (!$weatherData) {
    echo widget_meteo::renderNoData();
    return;
}
?>

<!-- Widget météo cliquable -->
<div class="weather-widget-container"
    <?php if (!empty($redirectUrl)): ?>onclick="window.location.href='<?php echo htmlspecialchars($redirectUrl); ?>'" style="cursor: pointer;" <?php endif; ?>>
    <div class="weather-widget">
        <h4 class="widget-title">Météo - <?php echo htmlspecialchars($weatherData['city']); ?></h4>
        <div class="current-weather">
            <?php
            // Déterminer si c'est le jour ou la nuit pour l'icône actuelle
            $currentHour = (int)date('H');
            $isDayCurrent = ($currentHour >= 6 && $currentHour < 20);
            $currentIcon = getWeatherIcon($weatherData['icon'], $isDayCurrent);
            ?>
            <div class="weather-icon"><?php echo $currentIcon; ?></div>
            <div class="current-info">
                <div class="condition-text"><?php echo htmlspecialchars($weatherData['condition']); ?></div>
                <div class="temp"><strong><?php echo htmlspecialchars($weatherData['tempC']); ?>°C</strong></div>
                <div class="details">
                    <?php if ($weatherData['windKph'] !== ''): ?>
                        <span>💨 Vent : <?php echo htmlspecialchars($weatherData['windKph'] . ' km/h ' . $weatherData['windDir']); ?></span>
                        <?php if ($weatherData['windGust'] && $weatherData['windGust'] > $weatherData['windKph']): ?>
                            <span style="color: #fc2e18ff;"> ____ 🌪️ Rafales : <?php echo htmlspecialchars($weatherData['windGust']); ?> km/h</span><br>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php if ($weatherData['humidity'] !== ''): ?>
                        <span>💧 Humidité : <?php echo htmlspecialchars($weatherData['humidity']); ?> %</span><br>
                    <?php endif; ?>
                    <?php if ($weatherData['sunrise'] !== '' && $weatherData['sunset'] !== ''): ?>
                        <span>🌅 <?php echo $weatherData['sunrise']; ?> — 🌇 <?php echo $weatherData['sunset']; ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php if (!empty($weatherData['forecast'])): ?>
            <div class="forecast-hourly">
                <?php foreach (array_slice($weatherData['forecast'], 0, 6) as $hour): ?>
                    <?php
                    // Déterminer si c'est le jour ou la nuit pour chaque heure
                    $hourTime = explode(':', $hour['time_fmt'])[0];
                    $isDayHour = ($hourTime >= 6 && $hourTime < 20);

                    // Obtenir l'icône adaptée jour/nuit
                    $hourIcon = !empty($hour['condition_icon']) ?
                        getWeatherIcon($hour['condition_icon'], $isDayHour) :
                        widget_meteo::get_weather_emoji($hour['condition']);
                    ?>
                    <div class="hour-block">
                        <div class="hour-time"><?php echo htmlspecialchars($hour['time_fmt']); ?></div>
                        <div class="hour-icon"><?php echo $hourIcon; ?></div>
                        <div class="hour-temp"><?php echo round($hour['temp'], 1); ?>°C</div>
                        <div class="hour-wind">
                            <?php echo htmlspecialchars(round($hour['wind_speed'], 1)); ?> km/h<br>
                            <?php echo htmlspecialchars(widget_meteo::wind_direction($hour['wind_deg'])); ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <?php if (!empty($redirectUrl)): ?>
            <div class="footer">Clic pour météo complète Open-Meteo</div>
        <?php endif; ?>
    </div>
</div>